<?php
/*--------------------------------------------------------------------------------------------------
    ServiceProvider.php 2020-06-02
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */
declare(strict_types=1);

namespace Gambio\Shop\Product\SellingUnitImage\Database;

use Doctrine\DBAL\Connection;
use Gambio\Core\Event\EventListenerProvider;
use Gambio\Core\Filesystem\Interfaces\Filesystem;
use Gambio\Core\Images\ValueObjects\ProductGalleryImages;
use Gambio\Core\Images\ValueObjects\ProductInfoImages;
use Gambio\Core\Images\ValueObjects\ProductOriginalImages;
use Gambio\Core\Images\ValueObjects\ProductPopUpImages;
use Gambio\Core\Images\ValueObjects\ProductThumbnailImages;
use Gambio\Shop\Product\SellingUnitImage\Database\Listerner\OnImageCollectionCreateEventListener;
use Gambio\Shop\Product\SellingUnitImage\Database\Repository\DTO\ImageDtoBuilder;
use Gambio\Shop\Product\SellingUnitImage\Database\Repository\DTO\Interfaces\ImageDtoBuilderInterface;
use Gambio\Shop\Product\SellingUnitImage\Database\Repository\Factories\ImageFactory;
use Gambio\Shop\Product\SellingUnitImage\Database\Repository\Factories\ImageFactoryInterface;
use Gambio\Shop\Product\SellingUnitImage\Database\Repository\Readers\Reader;
use Gambio\Shop\Product\SellingUnitImage\Database\Repository\Readers\ReaderInterface;
use Gambio\Shop\Product\SellingUnitImage\Database\Repository\Repository;
use Gambio\Shop\Product\SellingUnitImage\Database\Repository\RepositoryInterface;
use Gambio\Shop\Product\SellingUnitImage\Database\Service\ReadService;
use Gambio\Shop\Product\SellingUnitImage\Database\Service\ReadServiceInterface;
use Gambio\Shop\SellingUnit\Database\Image\Events\OnImageCollectionCreateEvent;
use League\Container\Container;
use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Container\ServiceProvider\BootableServiceProviderInterface;


/**
 * Class ServiceProvider
 *
 * @package Gambio\Shop\Product\SellingUnitImage\Database
 *
 * @property-read Container $container
 */
class ServiceProvider extends AbstractServiceProvider implements BootableServiceProviderInterface
{
    /**
     * @var array
     */
    protected $provides = [
        OnImageCollectionCreateEventListener::class
    ];


    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->container->share(OnImageCollectionCreateEventListener::class)->addArgument(ReadServiceInterface::class);

        $this->container->share(ReadServiceInterface::class, ReadService::class)
                        ->addArgument(RepositoryInterface::class);

        $this->container->share(RepositoryInterface::class, Repository::class)
                        ->addArgument(ReaderInterface::class)
                        ->addArgument(ImageFactoryInterface::class);

        $this->container->share(ReaderInterface::class, Reader::class)
                        ->addArgument(Connection::class)
                        ->addArgument(Filesystem::class)
                        ->addArgument(ImageDtoBuilderInterface::class, ImageDtoBuilder::class)
                        ->addArgument(ProductOriginalImages::class)
                        ->addArgument(ProductInfoImages::class)
                        ->addArgument(ProductPopUpImages::class)
                        ->addArgument(ProductThumbnailImages::class)
                        ->addArgument(ProductGalleryImages::class);
        $this->container->share(ImageDtoBuilderInterface::class, ImageDtoBuilder::class);
        $this->container->share(ImageFactoryInterface::class, ImageFactory::class);
    }



    /**
     * @inheritDoc
     */
    public function boot()
    {
        /**
         * @var EventListenerProvider $listener
         */
        $listener = $this->container->get(EventListenerProvider::class);
        $listener->attachListener(OnImageCollectionCreateEvent::class, OnImageCollectionCreateEventListener::class);
    }
}